
# coinToss.py

import random
import math
import matplotlib.pyplot as plt

MAX_TOSSES = 10**5

tot = 0
numPos = 0
numNeg = 0
cnts = [] 
for j in range(MAX_TOSSES):
  flip = random.choice(['H', 'T'])
  if flip == 'H':
    tot += 1
  else:
    tot -= 1 
  if tot > 0:
    numPos += 1
  else:
    numNeg += 1
  cnts.append(tot)

print(f"Pos: {(numPos/MAX_TOSSES):.2%}; Neg: {(numNeg/MAX_TOSSES):.2%}")
plt.plot(cnts)
plt.title("Coin Toss Heads")
plt.xlabel("Coin Tosses")
plt.ylabel("Head Count")
plt.axhline(y=0, color='k')

plt.show()
